/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnEquipmentChanged;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.enchantment.Enchantment;

public class HorseSwiftnessEnchantment
extends CustomEnchantment {
    public HorseSwiftnessEnchantment() {
        this.rarity(Enchantment.Rarity.RARE).category(Registries.HORSE_ARMOR).slots(EquipmentSlots.ARMOR).maxLevel(4).minLevelCost(level -> level * 6).maxLevelCost(level -> level * 6 + 15);
    }

    @AutoInstance
    public static class Handler {
        static final AttributeHandler SPEED_ATTRIBUTE = new AttributeHandler("76c3bea2-7ef1-4c4b-b062-a12355120ee7", "HorseSwiftnessBonus", Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE);
        final DoubleConfig speedBonus = new DoubleConfig(0.125, new Range((Number)0.01, (Number)1.0));
        final Supplier<HorseSwiftnessEnchantment> enchantment = Registries.HORSE_SWIFTNESS;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("HorseSwiftness").comment("Increases the horse's movement speed.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnEquipmentChanged.listen(this::updateSpeed).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> data.entity instanceof Animal)).addConfig((IConfigurable)this.speedBonus.name("speed_bonus").comment("Speed bonus multiplier per enchantment level.")).insertTo(group);
        }

        private void updateSpeed(OnEquipmentChanged.Data data) {
            float extraSpeed = this.speedBonus.asFloat() * (float)this.enchantment.get().getEnchantmentSum(data.entity, EquipmentSlots.ARMOR);
            SPEED_ATTRIBUTE.setValue((double)extraSpeed).apply(data.entity);
        }
    }
}

